/*
Change log
version 1.2.0   = Added Inventory option to the main menu.
version 1.1.0   = Added Full Screen and Window Mode options.
version 1.0.0   = Finished the plugin.
*/
/*:
@target MZ
@plugindesc v1.2.0 - Non RPG Main Menu with Full Screen/Window Mode and Inventory Option
@author Clay Davis
@help 
♦ About:
This plugin replaces the main menu with a non-RPG style menu that
only contains:
- Inventory
- Options
- Exit Game

New Features:
- Adds an Inventory option to access the Item screen.
- Includes buttons for toggling Full Screen and Window Mode.

♦ Terms of Use:
- MIT
*/

var NonRPGMenu = NonRPGMenu || {};
NonRPGMenu.MenuSystem = function() {
    Scene_Menu.prototype.create = function() {
        Scene_MenuBase.prototype.create.call(this);
        this.createCommandWindow();
    };

    Scene_Menu.prototype.commandWindowRect = function() {
        const ww = this.mainCommandWidth();
        const wh = Window_Base.prototype.lineHeight() * 3; // Adjusted height for three options
        const wx = (Graphics.boxWidth - ww) / 2;
        const wy = (Graphics.boxHeight - wh) / 2;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Menu.prototype.createCommandWindow = function() {
        const rect = this.commandWindowRect();
        const commandWindow = new Window_MenuCommand(rect);
        commandWindow.setHandler("inventory", this.commandInventory.bind(this)); // Added handler for Inventory
        commandWindow.setHandler("options", this.commandOptions.bind(this));
        commandWindow.setHandler("gameEnd", this.commandGameEnd.bind(this));
        commandWindow.setHandler("cancel", this.popScene.bind(this));
        this.addWindow(commandWindow);
        this._commandWindow = commandWindow;
    };

    Scene_Menu.prototype.commandInventory = function() {
        SceneManager.push(Scene_Item); // Open the default Item screen
    };

    Scene_Menu.prototype.commandGameEnd = function() {
        SceneManager.exit();
    };

    Scene_Menu.prototype.commandOptions = function() {
        SceneManager.push(Scene_Options);
    };

    Scene_Menu.prototype.start = function() {
        Scene_MenuBase.prototype.start.call(this);
    };

    Window_MenuCommand.prototype.makeCommandList = function() {
        this.addCommand("Inventory", "inventory"); // Added Inventory command
        this.addOptionsCommand();
        this.addCommand("Exit Game", "gameEnd");
    };

    function Scene_Options() {
        this.initialize(...arguments);
    }

    Scene_Options.prototype = Object.create(Scene_MenuBase.prototype);
    Scene_Options.prototype.constructor = Scene_Options;

    Scene_Options.prototype.initialize = function() {
        Scene_MenuBase.prototype.initialize.call(this);
    };

    Scene_Options.prototype.create = function() {
        Scene_MenuBase.prototype.create.call(this);
        this.createOptionsWindow();
    };

    Scene_Options.prototype.createOptionsWindow = function() {
        const rect = this.optionsWindowRect();
        this._optionsWindow = new Window_Options(rect);
        this._optionsWindow.setHandler("fullscreen", this.commandFullScreen.bind(this));
        this._optionsWindow.setHandler("windowMode", this.commandWindowMode.bind(this));
        this._optionsWindow.setHandler("cancel", this.popScene.bind(this));
        this.addWindow(this._optionsWindow);
    };

    Scene_Options.prototype.optionsWindowRect = function() {
        const ww = this.mainCommandWidth();
        const wh = this.calcWindowHeight(2, true); // Adjusted height for two options
        const wx = (Graphics.boxWidth - ww) / 2;
        const wy = (Graphics.boxHeight - wh) / 2;
        return new Rectangle(wx, wy, ww, wh);
    };

    Scene_Options.prototype.commandFullScreen = function() {
        if (!Graphics._isFullScreen()) {
            Graphics._switchFullScreen();
        }
        this._optionsWindow.activate();
    };

    Scene_Options.prototype.commandWindowMode = function() {
        if (Graphics._isFullScreen()) {
            Graphics._switchFullScreen();
        }
        this._optionsWindow.activate();
    };

    function Window_Options() {
        this.initialize(...arguments);
    }

    Window_Options.prototype = Object.create(Window_Command.prototype);
    Window_Options.prototype.constructor = Window_Options;

    Window_Options.prototype.initialize = function(rect) {
        Window_Command.prototype.initialize.call(this, rect);
        this.refresh();
    };

    Window_Options.prototype.makeCommandList = function() {
        this.addCommand("Full Screen", "fullscreen");
        this.addCommand("Window Mode", "windowMode");
    };

    Window_Options.prototype.windowWidth = function() {
        return 240;
    };

    Window_Options.prototype.windowHeight = function() {
        return this.fittingHeight(this.numVisibleRows());
    };

    Window_Options.prototype.numVisibleRows = function() {
        return 2; // Adjusted rows for two options
    };
};
NonRPGMenu.MenuSystem();
